function updater
%UPDATER update the global ramsey table
%
% 	UPDATER performs a number of simple checks 
%	to improve bounds: First RTABLE is compared 
%	to ETABLE to see if any new bounds have been
%	found, then all values are tested with the simplest 
%  	upper- and lower bound recursions.
%	Finally, a check is performed to see if any 
%       new exact values have been produced.

global RTABLE ETABLE

xmax=size(RTABLE,1); 
ymax=size(RTABLE,2);
excheck=1;

if ymax>size(ETABLE,2) %xmax >size(ETABLE,1) |  
   error('etable is smaller than rtable')
else % everything else...


% this checks the e-table to see if any new r-values can be extracted

for i=2:size(ETABLE,1)
   for j=2:ymax
      for n=2:size(ETABLE,3)
         if ETABLE(i,j,n).elb==Inf ...
               & ETABLE(i,j,n-1).elb~=Inf % if elb is inf, the enumber does not exist
            if RTABLE(i,j).ub>n     % only changes for the better are allowed!
               RTABLE(i,j).ub=n;
               RTABLE(j,i).ub=n; % NEW!
               RTABLE(i,j).ubinfo=[RTABLE(i,j).ubinfo,num2str(RTABLE(i,j).ub),':elb=Inf ' ];
               RTABLE(j,i).ubinfo=[RTABLE(j,i).ubinfo,num2str(RTABLE(j,i).ub),':elb=Inf ' ];
            end
            	m=n;
            while ETABLE(i,j,m).elb>0
               excheck=[excheck,ETABLE(i,j,m).exact];
               m=m-1;
            end
            if all(excheck) % all e-numbers are exact
               RTABLE(i,j).lb=n; % this implies that R is also exact
               RTABLE(i,j).lbinfo=[RTABLE(i,j).lbinfo,num2str(RTABLE(i,j).lb),':all exact '];
   	         RTABLE(j,i).lb=n;
               RTABLE(j,i).lbinfo=[RTABLE(j,i).lbinfo,num2str(RTABLE(j,i).lb),':all exact '];
               excheck=[];
            else
               excheck=[];
     			end
         end
      end
   end
end


% this is the upper-bound recursion including the strict inequality for 
% both numbers being even

for k=3:xmax
   for l=3:ymax % k:ymax
      if RTABLE(k,l).ub>RTABLE(k,l-1).ub+RTABLE(k-1,l).ub 
         RTABLE(k,l).ub = RTABLE(k,l-1).ub+RTABLE(k-1,l).ub; 
         if ((rem(RTABLE(k,l-1).ub,2)==0) & (rem(RTABLE(k-1,l).ub,2)==0)) 
            RTABLE(k,l).ub=RTABLE(k,l).ub-1;
         end
         RTABLE(k,l).ubinfo=[RTABLE(k,l).ubinfo,num2str(RTABLE(k,l).ub),':ub-recursion '];
      end
   end 
end

% this is the lower-bound r(i,j) > r(i,l)+r(i,j-l+1)-1

for i=3:xmax %this is done for a fixed x
   for j=3:ymax
      best=0;
      for l=2:ceil(j/2) 
         best=max(best,(RTABLE(i,l).lb+RTABLE(i,j-l+1).lb-1));
      end
      for k=2:ceil(i/2)  
         best=max(best,(RTABLE(k,j).lb+RTABLE(i-k+1,j).lb-1));
     
      end

      if RTABLE(i,j).lb<best+1; 
         RTABLE(i,j).lb=best+1; 
         RTABLE(i,j).lbinfo=[RTABLE(i,j).lbinfo,num2str(RTABLE(i,j).lb),':lb-recursion '];
      end
   end
end

% this checks if any new values have become exact by the upper and lower bounds coinciding
for i=3:xmax
   for j=3:ymax
      if RTABLE(i,j).ub==RTABLE(i,j).lb & not(RTABLE(i,j).exact)
         RTABLE(i,j).exact=1;
         RTABLE(i,j).ubinfo=[RTABLE(i,j).ubinfo,num2str(RTABLE(i,j).ub),':ub=lb '];         
         RTABLE(i,j).lbinfo=[RTABLE(i,j).lbinfo,num2str(RTABLE(i,j).lb),':ub=lb ']; 
      end
   end
end

end