function updatee
% UPDATEE Update the global enumbertable ETABLE
%
%	UPDATEE uses several recursive techniques
%	to improve bounds for e- and E-numbers.
%	theorem 4 and the delta inequality
%	are used to calculate lower bounds for e.
%	The bounds for E are adjusted so that 
% 	they agree with the bounds for e, for
%	example if elb=n then we know that
%	Elb must be greater than or equal to n.
%	Updatee also checks whether any new values
%	have become exact by upper and lower bounds
%	coinciding, and whether any values have 
%	lower bounds that are greater than upper
% 	bounds, in which case the number cannot 
% 	exist and is set to Inf.

global ETABLE

xmax=size(ETABLE,1);
ymax=size(ETABLE,2);
nmax=size(ETABLE,3);

% this checks for nonexistent enumbers
for i=2:xmax
   for j=2:ymax
      for k=2:nmax
         if ETABLE(i,j,k).elb==Inf ...
               | ETABLE(i,j,k).elb>ETABLE(i,j,k).Eub ...
               | ETABLE(i,j,k).Elb>ETABLE(i,j,k).Eub ...
            etoInf(i,j,k);
         end        
      end
   end
end


% this is the delta inequality and theorem4 combined
for y=3:ymax
   check=0;
   n=2;
   while (check<2) & (n<=nmax)
      check=adjustbounds(3,y,n);
      if ETABLE(3,y,n).elb<= ETABLE(3,y,n).Eub
         check=max([check;theorem4(3,y,n);delta(y,n);]);
      else
         ETABLE(3,y,n).info=[ETABLE(3,y,n).info,num2str(ETABLE(3,y,n).elb),'elb>Eub '];
         check=etoInf(3,y,n);
      end
      if check~=1
         n=n+1;
      end
   end
   while n<=nmax
      ETABLE(3,y,n).info=[ETABLE(3,y,n).info,num2str(ETABLE(3,y,n).elb),':lower Inf '];
      etoInf(3,y,n); 
      n=n+1;
   end   
end

% a simpler version of the above code for x>3
for x=4:xmax
   for y=3:ymax
     	check=0;
      n=2;
      while (check<2) & (n<=nmax)
         check=adjustbounds(x,y,n);
         if ETABLE(x,y,n).elb<= ETABLE(x,y,n).Eub
            check=max([check,theorem4(x,y,n)]);
         else
            ETABLE(x,y,n).info=[ETABLE(x,y,n).info,num2str(ETABLE(x,y,n).elb),'elb>Eub '];
            check=etoInf(x,y,n);
         end
         if check~=1
            n=n+1;
         end
      end
      while n<=nmax
         ETABLE(x,y,n).info=[ETABLE(x,y,n).info,num2str(ETABLE(x,y,n).elb),':lower Inf '];
         etoInf(x,y,n); 
         n=n+1;
      end   
   end
end

% this is a last check to see if any new values have become exact
for x=1:xmax
   for y=1:ymax
      for n=1:nmax
         if ETABLE(x,y,n).elb==ETABLE(x,y,n).eub & not(ETABLE(x,y,n).exact)
            ETABLE(x,y,n).exact=1;
         end
         if ETABLE(x,y,n).Elb==ETABLE(x,y,n).Eub & not(ETABLE(x,y,n).Exact)
            ETABLE(x,y,n).Exact=1;
         end
      end
   end
end

% anything below this line is a subfunction!

% etoInf: sets the enumber to Inf
function check=etoInf(i,j,k)
global ETABLE
ETABLE(i,j,k).elb=Inf;
ETABLE(i,j,k).Elb=Inf;
ETABLE(i,j,k).eub=Inf;
ETABLE(i,j,k).Eub=Inf;
ETABLE(i,j,k).exact=1;
ETABLE(i,j,k).Exact=1;
ETABLE(i,j,k).info=[ETABLE(i,j,k).info,'etoInf '];
check=2;

% adjustbounds: inequalities for upper and lower bounds
function check=adjustbounds(i,j,k)
global ETABLE
check=0;
if ETABLE(i,j,k).elb>ETABLE(i,j,k).Elb 
   ETABLE(i,j,k).Elb=ETABLE(i,j,k).elb;
   ETABLE(i,j,k).info=[ETABLE(i,j,k).info,num2str(ETABLE(i,j,k).elb),':elb>Elb '];
   check=1;
end
if ETABLE(i,j,k).eub>ETABLE(i,j,k).Eub 
   ETABLE(i,j,k).eub=ETABLE(i,j,k).Eub;
   ETABLE(i,j,k).info=[ETABLE(i,j,k).info,num2str(ETABLE(i,j,k).Eub),':eub>Eub '];
   check=1;
end

%this is the delta inequality preceeded by sigma(vi)=n and sigma(ivi)=2e
% it is only used for x=3 (and y>=3 since the values for y=2 are trivial)
function check=delta(y,n)
global ETABLE
check=0;
elb=ETABLE(3,y,n).elb;
i=floor(2*elb/n);
vi1=rem(2*elb,n);
i1=i+1;
vi=n-vi1;
% this is the delta inequality 
while (i<n-2) & ((mytimes(vi,(i^2+ETABLE(3,y-1,n-i-1).elb))+(mytimes(vi1,(i1^2+ETABLE(3,y-1,n-i-2).elb))))>n*elb) & (elb<=ETABLE (3,y,n).Eub) %if the delta ineq is not satisfied
   elb=elb+1; 
   i=floor(2*elb/n);
   vi1=rem(2*elb,n);
   i1=i+1;
   vi=n-vi1;
end
if ETABLE(3,y,n).elb<elb;
   ETABLE(3,y,n).elb=elb;
   ETABLE(3,y,n).info=[ETABLE(3,y,n).info,num2str(elb),':delta '];
   if elb==Inf
      check=2;
   else
      check=1;
   end
end

% the function mytimes is used by delta,
% it aviods errors in delta by defining
% 0*a=0 even if a is Inf or NaN.

function m=mytimes(a,b)
if a==0 | b==0
   m=0;
else
   m=a*b;
end


% this is theorem4 

function check=theorem4(x,y,n)
global ETABLE
ymax=size(ETABLE,2);
nmax=size(ETABLE,3);
check=0;
for l=2:y-1
   for m=2:n-1
      if (ETABLE(x,y-l+1,n-m).eub ~= Inf) & (ETABLE(x,l,m).eub ~= Inf)
         if ETABLE(x,y,n).eub>ETABLE(x,y-l+1,n-m).eub+ETABLE(x,l,m).eub
            ETABLE(x,y,n).eub=ETABLE(x,y-l+1,n-m).eub+ETABLE(x,l,m).eub;
            ETABLE(x,y,n).info=[ETABLE(x,y,n).info,num2str(ETABLE(x,y,n).eub),':theorem 4 '];
            check=1;
         end
      end
   end
end



