function turan
%TURAN upper bounds for E-numbers
%
% 	TURAN uses Turan's theorem to improve 
% 	values of Eub in the global variable
% 	ETABLE

global ETABLE
xmax=size(ETABLE,1);
ymax=size(ETABLE,2);
nmax=size(ETABLE,3);

for k=2:xmax
   for y=2:ymax
      for n=2:nmax
         q=floor(n/(k-1));
         r=rem(n,(k-1));
         bound=(n*(n-1)/2)-((q-1)*n+(q+1)*r)/2;
         if ETABLE(k,y,n).Eub>bound & ETABLE(k,y,n).Eub~=Inf
            ETABLE(k,y,n).Eub=bound;
            ETABLE(k,y,n).info=[ETABLE(k,y,n).info,num2str(bound),':turan '];
	 end
      end
   end
end

   