function ramseytable(xmax,ymax)
%RAMEYTABLE create global variable RTABLE
%
%	RAMSEYTABLE(xmax,ymax) creates
%	the global variable RTABLE: 
%	an xmax-by-ymax matrix of structures
%	 of two-color classical Ramsey numbers. 
%	The structrures have seven fields:
% 	rt.x and rt.y are the parameters R(x,y), 
%	rt.lb is the largest known lower bound, 
%	rt.ub is the upper bound, and rt.exact is true if 
% 	lb=ub. rt.ubinfo and rt.lbinfo are text strings 
%	with information on how the values
% 	were calculated.

% matlab 6 users decomment the next line and 
% remove the final line "global RTABLE"!
%global RTABLE 

if nargin ~= 2
   error ('specify the upper bounds for the table: RAMSEYTABLE(xmax,ymax)');
else
   for i=2:xmax 
      for j=2:ymax 
         RTABLE(i,j)=struct('x',i,'y',j,'lb',0,'ub',Inf,'exact',0,'lbinfo','','ubinfo','');
         if i==2            % trivial values of R(2,y) and R(x,2) = x or y
            RTABLE(i,j).ub=j;
            RTABLE(i,j).lb=j;
            RTABLE(i,j).exact=1;
            RTABLE(i,j).lbinfo='trivial ';
            RTABLE(i,j).ubinfo='trivial ';
         end
         if j==2
            RTABLE(i,j).ub=i;
            RTABLE(i,j).lb=i;
            RTABLE(i,j).exact=1;
            RTABLE(i,j).ubinfo='trivial ';
            RTABLE(i,j).lbinfo='trivial ';
         end 
      end
   end
end
global RTABLE