function manualr(x,y,lb,ub)
%MANUALR manually change a value in the ramsey table RTABLE
%
%	MANUALR(X,Y,N) changes the value of 
%	R(X,Y) (AND R(Y,X)!) to be exactly N
% 	MANUALR(X,Y,LB,UB) changes the lower
%	and upper bounds to LB and UB.
% 	The exact field and the info-fields are updated.

global RTABLE


if x<=size(RTABLE,1) & x<=size(RTABLE,2) & y<=size(RTABLE,1) & y<=size(RTABLE,2) % new value must fit! 
   if nargin == 3
      RTABLE(x,y).lb=lb;
      RTABLE(x,y).ub=lb;
      RTABLE(x,y).exact=1;
      RTABLE(x,y).lbinfo=[RTABLE(x,y).lbinfo,num2str(lb),':manual '];
      RTABLE(x,y).ubinfo=[RTABLE(x,y).ubinfo,num2str(lb),':manual '];
      
      if x~=y % diagonals such as r(3,3) should not be updated twice...
         RTABLE(y,x).lb=lb;
         RTABLE(y,x).ub=lb;
         RTABLE(y,x).exact=1;
         RTABLE(y,x).lbinfo=[RTABLE(y,x).lbinfo,num2str(lb),':manual '];
         RTABLE(y,x).ubinfo=[RTABLE(y,x).ubinfo,num2str(lb),':manual '];
      end
      
   elseif nargin == 4 
      RTABLE(x,y).lb=lb;
      RTABLE(x,y).ub=ub;
      
      if x~=y
         RTABLE(y,x).lb=lb;
         RTABLE(y,x).ub=ub;
      end
      if ub==lb
         RTABLE(x,y).exact=1;
         RTABLE(y,x).exact=1;
      end
      RTABLE(x,y).lbinfo=[RTABLE(x,y).lbinfo,num2str(lb),':manual '];
      RTABLE(x,y).ubinfo=[RTABLE(x,y).ubinfo,num2str(ub),':manual '];
      
      if x~=y
         RTABLE(y,x).lbinfo=[RTABLE(y,x).lbinfo,num2str(lb),':manual '];
         RTABLE(y,x).ubinfo=[RTABLE(y,x).ubinfo,num2str(ub),':manual '];
      end
      
      
   else error('manualr must have four or five arguments')
   end   
else error('value not in table')
end
