function manualelb(x,y,n,elb,info)
%MANUALELB manually update a value of elb
%
% 	MANUALELB(X,Y,N,ELB,INFO) sets 
% 	ETABLE(X,Y,N).elb to ELB and adds 
%	the string INFO to ETABLE(X,Y,N).info  


global ETABLE

if nargin ~= 5 | ~isstr(info)
   error('manualelb must have exactly 5 arguments,info must be a string')
else
   if ETABLE(x,y,n).elb < elb
      ETABLE(x,y,n).elb=elb;
      ETABLE(x,y,n).info=[ETABLE(x,y,n).info,num2str(elb),info];
  end 
end

