function t=exetable(x) 
global ETABLE
%EXETABLE Exact table of e numbers
%
% 	T=EXETABLE(X) extracts a y-by-n table 
%	of exact values for e numbers e(X,y,n)
%	from the global variable ETABLE

ymax=size(ETABLE,2);
nmax=size(ETABLE,3);
t=zeros(nmax,ymax);

for y=1:ymax
   for n=1:nmax
      if ETABLE(x,y,n).exact
         t(n,y)=ETABLE(x,y,n).eub;
      else
         t(n,y)=-1;
      end
   end
end








