function enumbertable(xmax,ymax,nmax)
%ENUMBERTABLE create global variable RTABLE
%
%	ENUMBERTABLE(xmax,ymax,nmax) creates
%	the global variable ETABLE: 
%	an xmax-by-ymax-by-nmax matrix of structures
%	of e-numbers and E-numbers for two-color 
%	classical Ramsey numbers. 
%	The structrures have twelve fields:
% 	et.x, et.y and et.n are the parameters e(x,y,n). 
%	et.elb is the largest known lower bound for e. 
%	et.eub is the upper bound for e.
%	et.Elb and et.Eub are lower and upper bounds for E.
%	et.exact is true if elb=eub.
%	et.Exact is true if Elb=Eub.
%	et.info is a text string 
%	with information on how the values
% 	were calculated.
%	et.graph is a graph object
%	et.minmaxval is a vector containing the minimum 
%	and maximum possible valences for a realiser.

% matlab 6 users: add "global ETABLE" here and delete it at end of file

if nargin ~= 3
   error ('specify the upper bounds for the table: ENUMBERTABLE(xmax,ymax,nmax)');
else %initialize struct array
   for i=1:xmax %??? e(1,1) is still there but empty? ok for now
      for j=1:ymax
         for k=1:nmax
            ETABLE(i,j,k) = struct('x',i,'y',j,'n',k, ...
               'elb',0,'eub',Inf,'exact',0, ... %eub=k*(k-1)/2
               'Elb',0,'Eub',k*(k-1)/2,'Exact',0,'info','',...
               'graph',graph([]),'minmaxval',[0 k-1]);
         end
      end
   end
end

% when y>n the enmubers are all 0

for x=1:xmax
   for n=1:nmax
      for y=n+1:ymax
         ETABLE(x,y,n).elb=0; 
         ETABLE(x,y,n).eub=0;
         ETABLE(x,y,n).Elb=0;
         ETABLE(x,y,n).Eub=0;
         ETABLE(x,y,n).exact=1;
         ETABLE(x,y,n).Exact=1;
         ETABLE(x,y,n).info=[ETABLE(x,1,n).info,'trivially 0 '];         
      end
   end
end

%for y=1 the enumbers do not exist

for x=1:xmax
   for n=1:nmax
      ETABLE(x,1,n).elb=Inf; 
      ETABLE(x,1,n).eub=Inf;
      ETABLE(x,1,n).Elb=Inf;
      ETABLE(x,1,n).Eub=Inf;
      ETABLE(x,1,n).exact=1;
      ETABLE(x,1,n).Exact=1;
      ETABLE(x,1,n).info=[ETABLE(x,1,n).info,'trivial '];
   end
end


% for y=2, n<=x-1 all edges are blue and there are (n 2) of them
for x=2:xmax
   for n=2:nmax
      if n<=x-1
         nc2=n*(n-1)/2;
         ETABLE(x,2,n).elb=nc2; 
         ETABLE(x,2,n).eub=nc2;
         ETABLE(x,2,n).Elb=nc2;
         ETABLE(x,2,n).Eub=nc2;
         ETABLE(x,2,n).exact=1;
         ETABLE(x,2,n).Exact=1;
         ETABLE(x,2,n).info=[ETABLE(x,2,n).info,'trivial '];
         ETABLE(x,2,n).graph=graph(not(eye(n)-zeros(n)));
         ETABLE(x,2,n).minmaxval=[nc2 nc2];
      end
   end
end

%for y=2 and n>=x the enumber does not exist

for x=2:xmax
   for n=2:nmax
      if n>=x
         ETABLE(x,2,n).elb=Inf; 
         ETABLE(x,2,n).eub=Inf;
         ETABLE(x,2,n).Elb=Inf;
         ETABLE(x,2,n).Eub=Inf;
         ETABLE(x,2,n).exact=1;
         ETABLE(x,2,n).Exact=1;
         ETABLE(x,2,n).info=[ETABLE(x,2,n).info,'trivial '];
      end
   end
end


% for x=2, n=y-1 we trivialy have a graph on y-1 points with no edges
for j=2:ymax
   ETABLE(2,j,j-1).elb=0; 
   ETABLE(2,j,j-1).eub=0;
   ETABLE(2,j,j-1).Elb=0;
   ETABLE(2,j,j-1).Eub=0;
   ETABLE(2,j,j-1).exact=1;
   ETABLE(2,j,j-1).Exact=1;
   ETABLE(2,j,j-1).info=[ETABLE(2,j,j-1).info,'trivial '];
   ETABLE(2,j,j-1).graph=graph(zeros(j-1));
   ETABLE(2,j,j-1).minmaxval=[0 0];
end
% for x=2 n>=y the enumber does not exist
for y=2:ymax
   for n=2:nmax
      if n>=y
         ETABLE(2,y,n).elb=Inf; 
         ETABLE(2,y,n).eub=Inf;
         ETABLE(2,y,n).Elb=Inf;
         ETABLE(2,y,n).Eub=Inf;
         ETABLE(2,y,n).exact=1;
         ETABLE(2,y,n).Exact=1;
         ETABLE(2,y,n).info=[ETABLE(2,y,n).info,'trivial '];
      end
   end
end


% upper bound for x=3
for j=2:ymax
   for k=2:nmax
      ETABLE(3,j,k).Eub=floor(k/2*(j-1));
   end
end

global ETABLE