function t=elbtable(x) 

%ELBTABLE Lower bounds for e numbers
%
% 	T=ELBTABLE(X) extracts a y-by-n table 
%	of lower bounds for e numbers e(X,y,n)
%	from the global variable ETABLE

global ETABLE
ymax=size(ETABLE,2);
nmax=size(ETABLE,3);
t=zeros(nmax,ymax);

for y=1:ymax
   for n=1:nmax
      t(n,y)=ETABLE(x,y,n).elb;
   end
end






