function t=eeubtable(x) 
global ETABLE
%EEUBTABLE Upper bounds for E numbers
%
% 	T=EEUBTABLE(X) extracts a y-by-n table 
%	of upper bounds for E numbers E(X,y,n)
%	from the global variable ETABLE

ymax=size(ETABLE,2);
nmax=size(ETABLE,3);
t=zeros(nmax,ymax);

for y=1:ymax
   for n=1:nmax
      t(n,y)=ETABLE(x,y,n).Eub;
   end
end







