function t=eelbtable(x) 
%EELBTABLE Lower bounds for E numbers
%
% 	T=EELBTABLE(X) extracts a y-by-n table 
%	of lower bounds for E numbers E(X,y,n)
%	from the global variable ETABLE

global ETABLE
ymax=size(ETABLE,2);
nmax=size(ETABLE,3);
t=zeros(nmax,ymax);

for y=1:ymax
   for n=1:nmax
      t(n,y)=ETABLE(x,y,n).Elb;
   end
end








