function g=graph(arg)
% GRAPH/GRAPH constructor for class graph
%
%	G=GRAPH(E) creates a new object 
% 	of type graph from the matrix E 
% 	containing the edge relationships.

if nargin == 0
   g.e = [];
   g.eig = [];
   g = class(g, 'graph');
   
elseif isempty(arg)
   g.e = [];
   g.eig = [];
   g = class(g, 'graph');
   
elseif isa(arg, 'graph')
   g = arg;
  
else
   t = transpose (arg);
   if all (all (t == arg)) % tests edge matrix for symmetry
      g.e = arg;
      g.eig = sort(eig(arg));
      g = class(g, 'graph');
   else error ('Edge matrix must be symmetric')
   end
end

