function gplot(g,lc)
%GRAPH/GPLOT plot the graph defined by g.e
%
%	GPLOT(G) plots the graph G
%	(the vertices are arranged in a circle) 
%	GPLOT(G,LC) plots the graph using the 
%	color specified by lc (see PLOT for
%	alternatives)

   axis equal;
   e = edges(g);
   n = size(e,1);
   v = ncircle(n);
   %clf;
   axis equal;
   hold on;
   if nargin < 2        % this if-clause allows 
      gplot(e,v);	% for different colors etc,
   else			% it is stolen from gplot.m
      gplot(e,v,lc);
   end
   plot(v(:,1),v(:,2),'o');
   hold off;
   
function V=ncircle(n)
%GRAPH/NCIRCLE(n) create circle of coordinates
%
%	V=NUCIRCLE(N) creates a n-x-2 matrix 
%	of coordinates [x(i) y (i)] 1<=i<=n,
% 	which are evenly spaced around a unit circle.

V=zeros(n,2);
theta=2*pi/n;
for i=1:n
   V(i,1)=cos(i*theta);
   V(i,2)=sin(i*theta);
end
